import Link from "next/link";

export default function CategoryPage({ params }: { params: { slug: string } }) {
  return (
    <div className="mx-auto max-w-6xl px-4 py-10">
      <div className="flex items-center justify-between">
        <div>
          <h2 className="text-2xl font-semibold tracking-tight capitalize">{params.slug.replaceAll("-", " ")}</h2>
          <p className="mt-1 text-sm text-neutral-600">This page will list products from active suppliers.</p>
        </div>
        <div className="flex gap-3 text-sm">
          <Link className="hover:underline" href="/catalog">Back</Link>
          <Link className="hover:underline" href="/cart">Cart</Link>
        </div>
      </div>

      <div className="mt-6 rounded-2xl border border-neutral-200 p-6 text-sm text-neutral-700">
        Wire-up: GET /api/catalog/products?category={params.slug}
      </div>
    </div>
  );
}
